#include <cstdio>
#include <iostream>
#include <string>
#include <vector>
#include <algorithm>
#include <cmath>
#include <cassert>
#include <memory.h>
#include <queue>
#include <deque>
#include <stack>
#include <list>
#include <map>
#include <set>
#include <functional>
#include <cstring>
#include <ctime>

using namespace std;

#define all(a) a.begin(), a.end()
#define mp make_pair

typedef long long li;
typedef long double ld;
typedef pair<int, int> pi;
typedef vector<int> vi;

#define FILENAME ""

void solve();
int main() {
#ifdef YA
	string s = FILENAME;
	//assert(!s.empty());
	clock_t start = clock();
	freopen("input.txt", "r", stdin);
	//freopen("output.txt", "w", stdout);
#else
	//freopen(FILENAME ".in", "r", stdin);
	//freopen(FILENAME ".out", "w", stdout);
	//freopen("input.txt", "r", stdin);
	//freopen("output.txt", "w", stdout);
#endif
	cout.sync_with_stdio(0);
	cin.tie(0);
	cout.precision(15);
	cout << fixed;

	int t = 1;
	//cin >> t;
	while(true) {
		solve();
	}
#ifdef YA
	cout << "\n\n" << (clock() - start) / 1.0 / CLOCKS_PER_SEC << "\n\n";
#endif
	return 0;
}


//#define int li

struct Point {
	ld x, y;
	Point() {}
	Point(ld x, ld y):x(x), y(y) {}
	Point operator + (const Point& ot) const {
		return Point(x + ot.x, y + ot.y);
	}
	Point operator - (const Point& ot) const {
		return Point(x - ot.x, y - ot.y);
	}
	ld operator * (const Point& ot) const {
		return x * ot.y - y * ot.x;
	}
	Point operator * (ld c) const {
		return Point(x * c, y * c);
	}
	ld operator % (const Point& ot) const {
		return x * ot.x + y * ot.y;
	}
	ld sqrDist() const {
		return x * x + y * y;
	}
	void print() {
		cout << x << ' ' << y << "\n";
	}
};

struct Line {
	Point p;
	Point vec;
	Line() {}
	Line(const Point& a, const Point& b) {
		p = a;
		vec = b - a;
	}
	Point intersect(const Line& ot) {
		ld det = vec * ot.vec;
		ld a = (ot.p - p) * ot.vec;
		ld t = (a / det);
		return p + vec * t;
	}
	Point reflect (const Point& a) {
		ld up = vec.x * (a.x - p.x) + vec.y * (a.y - p.y);
		ld down = vec.sqrDist();
		ld t = up / down;
		Point proj = p + vec * t;
		return proj * 2 - a;
	}
};

string s;
int pos;

struct Result {
	Point p;
	Line l;
	bool isPoint;
	Result(){}
	Result(const Point& p):p(p), isPoint(true) {}
	Result(const Line& l):l(l), isPoint(false) {}
};

Result getOp(Result a, Result b) {
	if (b.isPoint) {
		swap(a, b);
	}
	if (!a.isPoint) {
		return Result(a.l.intersect(b.l));
	}
	if (b.isPoint) {
		return Result(Line(a.p, b.p));
	}
	return Result(b.l.reflect(a.p));
}

int getNum() {
	int tmp = 1;
	if (s[pos] == '-') {
		tmp = -1;
		++pos;
	}
	int res = 0;
	while (s[pos] >= '0' && s[pos] <= '9') {
		res = res * 10 + int(s[pos] - '0');
		++pos;
	}
	return res * tmp;
}

Result getConcat();

Result getSmth() {
	assert(s[pos] == '(');
	++pos;

	if (s[pos] == '-' || (s[pos] >= '0' && s[pos] <= '9')) {
		int x = getNum();
		assert(s[pos] == ',');
		++pos;
		int y = getNum();
		assert(s[pos] == ')');
		++pos;
		return Result(Point(x, y));
	}
	
	Result res = getConcat();

	++pos;

	return res;
}

Result getConcat() {
	Result cur = getSmth();
	while (pos < s.size() && s[pos] == '@') {
		++pos;
		cur = getOp(cur, getSmth());
	}
	return cur;
}

void solve() {
	getline(cin, s);
	
	if (s == "#") {
		exit(0);
	}
	pos = 0;
	Result res = getConcat();
	assert(res.isPoint);
	res.p.print();
}